import pandas as pd
import pickle
from decision_company import read_csv_file, fetch_column, logical_or, search_where, extract_unique_values, assert_series


atp_tennis = read_csv_file('atp_tennis.csv')

# Find Federer matches
federer_matches = atp_tennis[logical_or(assert_series(atp_tennis['Player_1'], 'Federer R.', 'equality'), assert_series(atp_tennis['Player_2'], 'Federer R.', 'equality'))]

# Get Federer opponents
federer_opponents = extract_unique_values(search_where(fetch_column(federer_matches, 'Player_1'), assert_series(federer_matches['Player_1'], 'Federer R.', 'inequality'), federer_matches['Player_2'])) 

print(federer_opponents)
pickle.dump(federer_opponents,open("./ref_result/federer_opponents.pkl","wb"))